/*
 * This file is a part of IDDCoreFoundation framework.
 * Copyright (C) 1997-2007 Klajd(Clyde) M. Deda
 *
 * http://www.id-design.com/software/index.php
 * Free to use at your own risk.
 */


/************
** IMPORTS **
************/
#import "NSThread_IDDCoreFoundation.h"
#import "IDDLog.h"

/************
** STATICS **
************/
static int IDDLOG_THREAD_NO_MAX = 9999;
static unsigned int  IDDLOG_THREAD_NO[9999];
static int IDDLOG_THREAD_STATE = 0;

/**************
** FUNCTIONS **
**************/
#pragma mark -
#pragma mark Functions

int NSThread_reset() {
	int  threadIndex = 0;
	
	while (threadIndex < IDDLOG_THREAD_NO_MAX) {
		IDDLOG_THREAD_NO[threadIndex] = 0;
		threadIndex++;
	}
	IDDLOG_THREAD_STATE = 1;
}

int NSThread_threadIndex(NSThread* _this) {
	int  threadIndex = 0;
	unsigned int  threadID = (unsigned int)_this;

	if (IDDLOG_THREAD_STATE == 0) NSThread_reset();
	
	while ((threadIndex < IDDLOG_THREAD_NO_MAX) && (IDDLOG_THREAD_NO[threadIndex] != threadID)) threadIndex ++;
	if (threadIndex == IDDLOG_THREAD_NO_MAX) { // not found
		threadIndex = 0;
		while ((threadIndex < IDDLOG_THREAD_NO_MAX) && (IDDLOG_THREAD_NO[threadIndex] != 0)) threadIndex ++;
		
		if (threadIndex == IDDLOG_THREAD_NO_MAX) { // zero all slots
			threadIndex = 0;
			while (threadIndex < IDDLOG_THREAD_NO_MAX) {
				IDDLOG_THREAD_NO[threadIndex] = 0;
				threadIndex++;
			}
			threadIndex = 0;
		}
		IDDLOG_THREAD_NO[threadIndex] = threadID;
	}
	return threadIndex;
}

/*******************
** IMPLEMENTATION **
*******************/
@implementation NSThread (NSThread_IDDCoreFoundation)

#pragma mark -
#pragma mark Instance methods

- (int)threadIndex {
	return NSThread_threadIndex(self);
}

@end
