/*
 * This file is a part of IDDCoreFoundation framework.
 * Copyright (C) 1997-2007 Klajd(Clyde) M. Deda
 *
 * http://www.id-design.com/software/index.php
 * Free to use at your own risk.
 */


/************
** IMPORTS **
************/
#import "NSFileManager_IDDCoreFoundation.h"
#import "IDDLog.h"

/*******************
** IMPLEMENTATION **
*******************/
@implementation NSFileManager (NSFileManager_IDDCoreFoundation)

#pragma mark -
#pragma mark Instance methods

- (BOOL)createDirectoryAtPath:(NSString*)aPath attributes:(NSDictionary*)attributes recursive:(BOOL)yesNo {
    NSString*  parentPath = nil;
    BOOL  isDir;
	
    if ([self fileExistsAtPath:aPath isDirectory:&isDir] && isDir) return YES;
    parentPath = [aPath stringByDeletingLastPathComponent];
    if ([self createDirectoryAtPath:parentPath attributes:attributes recursive:yesNo]) {
        BOOL  rv = [self createDirectoryAtPath:aPath attributes:attributes];
        
        if (!rv) {
            IDDLog::error(self, _cmd, @"Could not create (%@)", aPath);
        }
        return rv;
    }
    return NO;
}

- (BOOL)removeEmptyFolderAtPath:(NSString*)aPath {
    return [self removeEmptyFolderAtPath:aPath recurseLevelsBelow:0];
}

- (BOOL)removeEmptyFolderAtPath:(NSString*)aPath recurseLevelsBelow:(int)recurseLevel {
    NSArray*  folderList = [self directoryContentsAtPath:aPath];
    int   count = [folderList count];
    BOOL  blastIT = (count == 0);
    BOOL  rv = NO;
    
    if ((!blastIT) && (count == 1)) blastIT = [[folderList objectAtIndex:0] hasPrefix:@"."];
    if (blastIT) {
        if (![self removeFileAtPath:aPath handler:nil]) {
            IDDLog::error(self, _cmd, @"Could not remove (%@)", aPath);
        } else {
            rv = YES;
            IDDLog::debug(self, _cmd, @"Removed (%@)", aPath);
            if (recurseLevel > 0) {
                NSString*  pathBelow = [aPath stringByDeletingLastPathComponent];
                return [self removeEmptyFolderAtPath:pathBelow recurseLevelsBelow:(recurseLevel - 1)];
            }
        }
    }
    return rv;
}

@end
