/*
 * This file is a part of IDDCoreFoundation framework.
 * Copyright (C) 1997-2007 Klajd(Clyde) M. Deda
 *
 * http://www.id-design.com/software/index.php
 * Free to use at your own risk.
 */


/************
** IMPORTS **
************/
#import "IDDLogLoader.h"
#import "IDDLog.h"

/*******************
** IMPLEMENTATION **
*******************/
@implementation IDDLogLoader

#pragma mark -
#pragma mark Class methods

+ (void)load {
	static int  didIt = 0;
	
	if (!didIt) {
		NSAutoreleasePool*  pool = [[NSAutoreleasePool alloc] init];
		BOOL  standardLog = ([[NSUserDefaults standardUserDefaults] objectForKey:@"standardLog"] && [[NSUserDefaults standardUserDefaults] boolForKey:@"standardLog"]);
		NSString*  path = [[NSBundle mainBundle] pathForResource:@"IDDLog" ofType:@"plist"];

		if (standardLog) {
			IDDLog::standardLog();
		} else {
			NSString*  logFile = ([[NSUserDefaults standardUserDefaults] objectForKey:@"logFile"]);
			
			if ([logFile length]) {
				IDDLog::standardLog(logFile, NO);
			} else {
				IDDLog::userLibraryLog([[NSProcessInfo processInfo] processName], NO);
			}
		}
		NSLog(@"config log from path %@", path);
		if ([path length]) {
			NSDictionary*  logConfig = [NSDictionary dictionaryWithContentsOfFile:path];
			IDDLog::loadLevelsFromArgumentLine([logConfig objectForKey:@"IDDLogDefaults"]);
		}
		[pool release];
		didIt = 1;
	}
}

@end
