/*
 * This file is a part of IDDCoreFoundation framework.
 * Copyright (C) 1997-2007 Klajd(Clyde) M. Deda
 *
 * http://www.id-design.com/software/index.php
 * Free to use at your own risk.
 *
 * Reusable loggin logic. When loggin it will
 * force a certain format so that the log file can be parsed
 * back into a nice representation.
 *
 * Usage is simple  
 * IDDLog::info(self, _cmd, @"Print arg1:%@ arg2:%@", argment1, arg2);
 * Levels can be set on the command line or the IDDLog.plist file.
 * Check included example file IDDLogExample.plist
 */


#ifndef __IDDLog_H
#define __IDDLog_H

/************
** IMPORTS **
************/
#import <Foundation/Foundation.h>
#import "NSFileManager_IDDCoreFoundation.h"
#import "NSThread_IDDCoreFoundation.h"

/**************
** INTERFACE **
**************/
class IDDLog {

/**********
** IVARS **
**********/
private:
    NSRecursiveLock*  lock;
    NSFileHandle*  fileHandle;
    int  lastWrite;
    BOOL  rotate;
    NSString*  baseName;

    
/**************
** FUNCTIONS **
**************/
public:
    IDDLog();
    IDDLog(NSString* fileName, BOOL rotateFlag);
	~IDDLog();

	void setLogFileName(NSString* aValue, BOOL rotateFlag);
    NSString* logFileName();

    /*
     * Will return the shared instance, to create one logging
     * to a particular file use one of the initWithFilename:
     * methods to create the shared instance.
     */
    static IDDLog* standardLog();
    static IDDLog* standardLog(NSString* fileName, BOOL rotateFlag);
    static IDDLog* userLibraryLog(NSString* appName, BOOL rotateFlag);
    
    /*
     * define logLevel as an argument with values N, D, T or E
     */
    static void setLevelFromUserDefaults();
    static void loadLevelsFromArgumentLine(NSString* aValue);
    
    static void setLevelError();        
    static void setLevelInfo();
    static void setLevelDebug();
    static void setLevelTrace();        
    
    static BOOL errorLevel(id sender);
    static BOOL infoLevel(id sender);
    static BOOL debugLevel(id sender);
    static BOOL traceLevel(id sender);

    static void error(id sender, SEL aSelector, NSString *theEntry, ...);
    static void info(id sender, SEL aSelector, NSString *theEntry, ...);
    static void debug(id sender, SEL aSelector, NSString *theEntry, ...);
    static void trace(id sender, SEL aSelector, NSString *theEntry, ...);
        
private:
    BOOL openfile();
    int logLevelForNSString(NSString* _this);
    int isNSStringClass(struct objc_object* _this);
    int levelForID(NSObject* _this);
    void log(int aLevel, id sender, SEL aSelector, NSString *theEntry, va_list args);
};

#endif
